﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class LinkResolveIgnoreLinkInfo : UserControl, ICorrespondenceOS, IControl
    {
        private LinkResolveIgnoreLinkInfoController linkResolveIgnoreLinkInfoController;

        public LinkResolveIgnoreLinkInfo()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsVista_SP2,
                                           OS.WindowsSeven
#endif
                                       };
        }

        public void SetLinkResolveIgnoreLinkInfoState(bool b)
        {
            checkBox1.Checked = b;
        }

        public bool GetLinkResolveIgnoreLinkInfoState()
        {
            return checkBox1.Checked;
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:linkresolveignorelinkinfo"));
                userHelp.Show();
            }
        }

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IControl メンバ

        public void Apply()
        {
            linkResolveIgnoreLinkInfoController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return linkResolveIgnoreLinkInfoController.BackUp();
        }

        #endregion

        private void LinkResolveIgnoreLinkInfo_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            linkResolveIgnoreLinkInfoController = new LinkResolveIgnoreLinkInfoController(this,
                                                                                          (
                                                                                          ILinkResolveIgnoreLinkInfoStrategy
                                                                                          )
                                                                                          wfUtillity.
                                                                                              GetCorrespondenceInstance
                                                                                              (new List
                                                                                                   <ICorrespondenceOS>
                                                                                                   {
                                                                                                       new LinkResolveIgnoreLinkInfoDefaultStrategy
                                                                                                           ()
                                                                                                   }));
            linkResolveIgnoreLinkInfoController.Read();
        }
    }
}